function alEscape () {
	this.replace("'","\'");
}

function alOut(aText) {
	var csClass = Components.classes['@mozilla.org/consoleservice;1'];
	var cs = csClass.getService(Components.interfaces.nsIConsoleService);
	cs.logStringMessage('['+ new Date().toTimeString() +']\n'+ aText);
}

var AutoLoginSettings = {
	load: function () {
		this.siteList = document.getElementById('siteList'); 
		this.siteName = document.getElementById('siteName');
		this.siteURL = document.getElementById('siteURL');
		this.siteLogin = document.getElementById('login');
		this.sitePass = document.getElementById('pass');
		this.siteAcceptChanges = document.getElementById('acceptChanges');
		this.siteEnabled = document.getElementById('enabled');		
		this.prefs = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefService).getBranch('AutoLogin.');
		
		this.siteIndex = this.prefs.getCharPref('siteIndex').split(' ');
		if (this.siteIndex[0] == '') {
			// disables site panel and returns
			var sitePanChildren = document.getElementById('sitePanel').childNodes;
			for (var x in sitePanChildren) {
				sitePanChildren[x].disabled = true;
				if (sitePanChildren[x].tagName == 'hbox') {
					var hboxa = sitePanChildren[x].childNodes;
					for (var y in hboxa)
						hboxa[y].disabled = true;
				}
			}
			return;
		}
		
		for (var x in this.siteIndex) {
			var itemName = this.prefs.getCharPref('site'+ this.siteIndex[x]).split(' | ')[0];
			var item = this.siteList.appendItem(itemName);  
			item.value = this.siteIndex[x];			
		}
		this.siteList.selectItem(this.siteList.getItemAtIndex(0));
	},
	save: function () {},
	addSite: function () {
		var siteId = this.siteIndex[(this.siteIndex.length-1)]-0+1;
		if (this.siteIndex[0] == '') {
			this.siteIndex[0] = siteId;
			// first site. enable site panel
			var sitePanChildren = document.getElementById('sitePanel').childNodes;
			for (var x in sitePanChildren) {
				sitePanChildren[x].disabled = false;
				if (sitePanChildren[x].tagName == 'hbox') {
					var hboxa = sitePanChildren[x].childNodes;
					for (var y in hboxa)
						hboxa[y].disabled = false;
				}
			}
		}
		else
			this.siteIndex.push(siteId);
		this.prefs.setCharPref('siteIndex',this.siteIndex.join(' '));
		this.prefs.setCharPref('site'+siteId,['New Site',,,,,'false'].join(' | '));
		
		var siteItem = this.siteList.appendItem('New Site');
		siteItem.value = siteId;
		this.siteList.selectItem(siteItem);
	},
	removeSite: function () {
		if (!this.siteList.selectedItem)
			return;		
		var siteId = this.siteList.selectedItem.value;
		var selectedIndex = this.siteList.selectedIndex;
		for (var x in this.siteIndex)
			if (this.siteIndex[x] == siteId)
				this.siteIndex.splice(x,1);
		
		this.prefs.setCharPref('siteIndex',this.siteIndex.join(' '));
		this.prefs.clearUserPref('site'+siteId);
		this.prefs.setCharPref('site'+siteId+'data','');
		if (this.siteList.getRowCount() > 1)
			this.siteList.selectItem(this.siteList.getItemAtIndex(selectedIndex+(!selectedIndex?1:-1)));
		else {
			// last site in list, disables site panel
			var sitePanChildren = document.getElementById('sitePanel').childNodes;
			for (var x in sitePanChildren) {
				sitePanChildren[x].disabled = true;
				switch (sitePanChildren[x].tagName) {
					case 'textbox':
						sitePanChildren[x].value = '';
						break;
					case 'checkbox':
						sitePanChildren[x].checked = false;
						break;
					case 'hbox':
						this.siteEnabled.checked = false;
						var hboxa = sitePanChildren[x].childNodes;
						for (var y in hboxa)
							hboxa[y].disabled = true;
						break;
				}
			}
		}
		this.siteList.removeItemAt(selectedIndex);		
		
		// updates quick URL list
		var quickURL = this.prefs.getCharPref('quickURL').split(' | ');
		for (var i=0; i<quickURL.length; i += 2)
			if (quickURL[i] == siteId) 
				quickURL.splice(i,2);
			
		this.prefs.setCharPref('quickURL',quickURL.join(' | '));
	},
	renameSite: function () {
		if (!this.siteList.selectedItem)
			return;
		this.siteList.selectedItem.label = this.siteName.value;		

		var siteValues = this.prefs.getCharPref('site'+this.siteList.selectedItem.value).split(' | ');
		siteValues[0] = this.siteName.value;
		this.prefs.setCharPref('site'+this.siteList.selectedItem.value,siteValues.join(' | '));		
	},
	updatePrefs: function () {
		// updates general values
		if (!this.siteList.selectedItem)
			return;
		var siteId = this.siteList.selectedItem.value;
		var siteValues = [
			this.siteName.value, 	
			this.siteURL.value,
			this.shuffle(this.siteLogin.value),
			this.shuffle(this.sitePass.value),
			this.siteAcceptChanges.checked,
			this.siteEnabled.checked
		].join(' | ');
		this.prefs.setCharPref('site'+ siteId,siteValues);
		
		// updates quick URL list
		var quickURL = this.prefs.getCharPref('quickURL').split(' | ');
		for (var i=0; i<quickURL.length; i += 2)
			if (quickURL[i] == siteId) {
				if (this.siteEnabled.checked) 
					quickURL[i+1] = this.siteURL.value;
				else 
					quickURL.splice(i,2);
				break;
			}
				
		// id not found, new item
		if (this.siteEnabled.checked && i >= quickURL.length && quickURL.length != 0) {
			quickURL.push(siteId);
			quickURL.push(this.siteURL.value);
			if  (quickURL.length == 3) 
				// quickURL was previously empty, make sure its length is an even number 
				quickURL.splice(0,1);			
		}
		
		this.prefs.setCharPref('quickURL',quickURL.join(' | '));
	},
	
	updateForm: function (siteId) {	
		if (!arguments.length) 
			if (this.siteList.selectedItem)			
				var siteId = this.siteList.selectedItem.value;
			else
				return;
		
		var siteArr = this.prefs.getCharPref('site'+ siteId).split(' | ');			
		this.siteName.value = siteArr[0];		
		this.siteURL.value = siteArr[1];
		this.siteLogin.value = this.unshuffle(siteArr[2]);
		this.sitePass.value = this.unshuffle(siteArr[3]); 
		this.siteAcceptChanges.checked = siteArr[4]=='true'?1:0;
		this.siteEnabled.checked = siteArr[5]=='true'?1:0;
	},	
	startCapture: function () {
		if (!this.siteList.selectedItem)
			return;		
		this.updatePrefs();
		this.prefs.setCharPref('captureFields',this.siteList.selectedItem.value);		
	},
	shuffle: function (input) {
		var output = '', tmp='',tmpout='';
		input = encodeURIComponent(input);	
		for (var i = 0; i < input.length; i++) 
			output += input.charCodeAt(i) - 23;
		
		for (var j = 0; j < output.length; j+=3) {
			tmp = output.substr(j,3);
			if (tmp.length == 3 && !j%6) 
				tmpout += tmp.charAt(2) + tmp.charAt(1) + tmp.charAt(0);
			else 
				tmpout += tmp;
		}
		
		return tmpout;	
	},
	unshuffle: function (input) {
		var output = '',tmpin='',tmp;
	
		for (var j = 0; j < input.length; j+=3) {
			tmp = input.substr(j,3);
			if (tmp.length == 3 && !j%6) 
				tmpin += tmp.charAt(2) + tmp.charAt(1) + tmp.charAt(0);
			else 
				tmpin += tmp;
		}
		input = tmpin;
		
		for (var i = 0; i < input.length; i += 2) {
			tmp = parseInt(input.substr(i,2)) + 23;
			output += decodeURIComponent('%' + tmp.toString(16));
		}	
		return decodeURIComponent(output);
	}
};


