function alDump(aText) {
	var csClass = Components.classes['@mozilla.org/consoleservice;1'].getService(Components.interfaces.nsIConsoleService);
	csClass.logStringMessage('['+ new Date() +']\n'+ aText);
}

window.addEventListener("load",autoLoginWinLoad, false);
function autoLoginWinLoad () {	
	document.getElementById("contentAreaContextMenu").addEventListener("popupshowing", function () { AutoLogin.onPop() }, true);
}

window.getBrowser().addEventListener('load', autoLoginTabLoad, true);
function autoLoginTabLoad (e) {
	AutoLogin.onLoad(e);
}

function AutoLoginCaptureWizard (evt) { 
	AutoLogin.captureWizard(evt);
};
function autoLoginNukeErrorIcon () {
	document.getElementById('autologinError').setAttribute('hidden','true');	
}

var AutoLogin = {
	msgs: {
		NON_CRITICAL: 'The current page appears to have changed, but AutoLogin probably still works with it. If you think it shouldn\'t proceed, choose Cancel, otherwise choose Ok. Changes will take effect after reloading the page.',
		CRITICAL: 'The current page appears to have changed. Please run the Capture Wizard again.'
	},
	onLoad: function (e) {
		var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("AutoLogin.");
		if (!prefs.prefHasUserValue('siteIndex')) {
			prefs.setCharPref('siteIndex','');
			prefs.setCharPref('quickURL','');
			prefs.setCharPref('captureFields','false');
		} 
		else {		
			var tUrls = prefs.getCharPref('quickURL').split(' | ');
			var url = e.originalTarget.location.href;
			for (var j=1,tUrlslen=tUrls.length;j< tUrlslen;j+=2) {
				if (!url.indexOf(tUrls[j])) {
					this.doAutoLogin(tUrls[(j-1)],e.originalTarget,e.originalTarget.defaultView);
				}
			}
		}
	},
	dumpObj: function (obj) {
		var s='';
		for (var prop in obj) 
			s+=prop+': '+obj[prop] +'\n';
		return s;			
	},
	doAutoLogin: function (siteId, doc, eWindow) {
		var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("AutoLogin.");
		var siteData = prefs.getCharPref('site'+siteId+'data').split(' ** ');
		var loginValues = prefs.getCharPref('site'+siteId).split(' | ');
		var	acceptChanges = loginValues[4];
			loginValues = [loginValues[2],loginValues[3]];
		var error = 0;
		
		for (var i=0; i < siteData.length; i++) {
			var fieldData = siteData[i].split(' | ');
			if (fieldData[0] == 1) {
				// Field is a form element
				/*
				1,
				f,
				form.getAttribute('method'),
				i,
				target.getAttribute('name'),
				target.getAttribute('id'),
				target.getAttribute('type')
				*/
				var form = doc.forms[fieldData[1]];
				var field = form?form.elements[fieldData[3]]:0;
				if (form && field && (form.getAttribute('method') == fieldData[2] || (!form.getAttribute('method') && !fieldData[2]))) {
					if ((field.getAttribute('name') != fieldData[4] && !(!field.getAttribute('name') && !fieldData[4])) ||
						(field.getAttribute('type') != fieldData[6] && !(!field.getAttribute('type') && !fieldData[6]))) 
					{
						// field index changed. try to find it again by its name.
						for (var j=0; j<form.elements.length; j++) {
//							alDump('name: '+ form.elements[j].getAttribute('name') +' | '+ fieldData[4]	+'\ntype: '+ form.elements[j].getAttribute('type') +' | '+ fieldData[6]);
							if ((form.elements[j].getAttribute('name') == fieldData[4] || (!form.elements[j].getAttribute('name') && !fieldData[4])) &&
								(form.elements[j].getAttribute('type') == fieldData[6] || (!form.elements[j].getAttribute('type') && !fieldData[6])))
							{
								if  (field.getAttribute('id') != fieldData[5] && !(!field.getAttribute('id') && !fieldData[5])) 
									// id doesn't match. alert error
									error += this.errOut(0,this.msgs.NON_CRITICAL+' [err 0]',eWindow, siteId);									

								//  found one with the same name and type, probably what we're looking for
//								alDump('field found');
								field = form.elements[j];
								break;
							}
						}
						if (j == form.elements.length) {
							// didn't find any relevant field, fatal error
							error += this.errOut(1,this.msgs.CRITICAL+' [err 1]',eWindow, siteId);
						}
					} else if  (field.getAttribute('id') != fieldData[5] && !(!field.getAttribute('id') && !fieldData[5])) 
					{
						// id doesn't match. alert error
						error += this.errOut(0,this.msgs.NON_CRITICAL+' [err 2]',eWindow, siteId);
					}
				} else {
					// form method changed, fatal error
					error += this.errOut(1,this.msgs.CRITICAL+' [err 3]',eWindow, siteId);
				}
				
			} else {
				// Field is outsite any form
//				alDump('field is outside form. \nTag name: '+ fieldData[1] +'\nTag index: '+ fieldData[2] );
				/*
				0,
				target.tagName,
				i,
				target.getAttribute('name'),
				target.getAttribute('id'),
				target.getAttribute('type'),
				target.getAttribute('onclick'),
				target.getAttribute('src'),
				target.getAttribute('href')
				*/
				var field = doc.getElementsByTagName(fieldData[1])[fieldData[2]];
				if  (!field ||					
					(field.getAttribute('name') != fieldData[3] && !(!field.getAttribute('name') && !fieldData[3])) ||
					(field.getAttribute('id') != fieldData[4] && !(!field.getAttribute('id') && !fieldData[4])) ||
					(field.getAttribute('type') != fieldData[5] && !(!field.getAttribute('type') && !fieldData[5])) ||
					(field.getAttribute('onclick') != fieldData[6] && !(!field.getAttribute('onclick') && !fieldData[6])) ||
					(field.getAttribute('src') != fieldData[7] && !(!field.getAttribute('src') && !fieldData[7])) ||
					(field.getAttribute('href') != fieldData[8] && !(!field.getAttribute('href') && !fieldData[8]))
					) {
					// field doesn't match, look for it in its neighboors (8 max)
//					alDump('field not found or with wrong params. looking for the right one...');
					
					var fields = doc.getElementsByTagName(fieldData[1]);
					var maxNeighbors = 8;
					if (fields.length > maxNeighbors) {
						var startIndex = fieldData[2]- maxNeighbors/2;
						var lastIndex = fieldData[2]+ maxNeighbors/2;
						startIndex = startIndex < 0 ? 0 : startIndex;
						lastIndex = lastIndex >= fields.length ? (fields.length - 1) : lastIndex;
					} else {
						var startIndex = 0;
						var lastIndex = fields.length - 1;
					}
					
					for (; startIndex<=lastIndex; startIndex++) {
						if  (
							(fields[startIndex].getAttribute('name') == fieldData[3] || (!fields[startIndex].getAttribute('name') && !fieldData[3])) &&
							(fields[startIndex].getAttribute('id') == fieldData[4] || (!fields[startIndex].getAttribute('id') && !fieldData[4])) &&
							(fields[startIndex].getAttribute('type') == fieldData[5] || (!fields[startIndex].getAttribute('type') && !fieldData[5])) &&
							(fields[startIndex].getAttribute('onclick') == fieldData[6] || (!fields[startIndex].getAttribute('onclick') && !fieldData[6])) &&
							(fields[startIndex].getAttribute('src') == fieldData[7] || (!fields[startIndex].getAttribute('src') && !fieldData[7])) &&
							(fields[startIndex].getAttribute('href') == fieldData[8] || (!fields[startIndex].getAttribute('href') && !fieldData[8]))
							) {
//							alDump('found field at index '+ startIndex);	
							field = fields[startIndex];
							break;
						}
					}
					
					if (startIndex > lastIndex) {
						error += this.errOut(1,this.msgs.CRITICAL+' [err 4]',eWindow, siteId);
					}
					
				}
			}
			if (!error) {
				// field was confirmed. proceed to fill or click it
				
				if (i == (siteData.length - 1)) {
					// last field is always a submit button					
					var evt = doc.createEvent('MouseEvents');
					evt.initMouseEvent('click',true,true,eWindow,0,0,0,0,0,false,false,false,false,0,undefined);				
					field.dispatchEvent(evt);
				} else if (siteData.length == 2) {
//					alDump('2 fields');
					// only one text field. check from prefs which one has data in it and populate field with its value
					field.value = this.unshuffle((loginValues[0] == ''?loginValues[1]:loginValues[0]));
				} else {
					// two text fields, data should match the prefs
//					alDump('3 fields');					
					field.value = this.unshuffle(loginValues[i]);
				}
				 
			} else { 
//				alDump('Error found. Aborting...');
				break;
			}
		}
	},
	onPop: function () {		
		var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("AutoLogin.");
		document.getElementById('autoLoginCapture').hidden = (prefs.getCharPref('captureFields')=='false'?true:false);		
	},
	captureStart: function (evt) {
		/*
			0- Name
			1- URL
			2- Login
			3- Pass
			4- Fast Method		
		*/			
		var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("AutoLogin.");
		this.wizSiteId = prefs.getCharPref('captureFields');
		var siteValues = prefs.getCharPref('site'+this.wizSiteId).split(' | ');		
		
		var url = document.commandDispatcher.focusedWindow.location.href;
		// if url field is empty, set it to the current url
		if (!siteValues[1]) {
			siteValues[1]=url;
			prefs.setCharPref('site'+this.wizSiteId,siteValues.join(' | '));
		} else if (url.indexOf(siteValues[1])) {
			// Check if current url matches the one set at preferences			
			alert('The current URL doesn\'t match the one you specified in the AutoLogin preferences window. Please refer to the AutoLogin help if you\'re having trouble.');
			return;
		}		
		// resets fields data
		prefs.setCharPref('site'+ this.wizSiteId +'data','');
		document.commandDispatcher.focusedWindow.addEventListener('click', AutoLoginCaptureWizard, true);
		
		if (siteValues[2]) {
			this.wizStep = 1;
			alert('Please click on the login field');
		}
		else if (siteValues[3]) {
			this.wizStep = 2;
			alert('Please click on the password field');
		}
		else { 
			this.wizStep = 3;
			alert('Please click on the submit button');
		}
	},
	captureWizard: function (evt) {
		var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("AutoLogin.");
		var siteValues = prefs.getCharPref('site'+this.wizSiteId).split(' | ');
		var siteDataStr = 'site'+ this.wizSiteId +'data';
		prefs.setCharPref('captureFields','false');
		switch (this.wizStep) {
			case 1:
				prefs.setCharPref(siteDataStr,this.captureGatherInfo(evt.target) +' ** ');
				if (siteValues[3]) {
					this.wizStep++;
					alert('Login field successfully captured.\nPlease click on the password field');					
				} else {
					this.wizStep += 2;					
					alert('Login field successfully captured.\nPlease click on the submit button');
				};
				break;
			case 2:
				prefs.setCharPref(siteDataStr,prefs.getCharPref(siteDataStr) + this.captureGatherInfo(evt.target) +' ** ');
				this.wizStep++;
				
				alert('Password field successfully captured.\nPlease click on the submit button');
				break;
			case 3:	
				prefs.setCharPref(siteDataStr,prefs.getCharPref(siteDataStr) + this.captureGatherInfo(evt.target));			
				this.wizStep = 0;
//				alDump('terminou');
				document.commandDispatcher.focusedWindow.removeEventListener('click', AutoLoginCaptureWizard,true);
				
				alert('Submit button successfully captured. The AutoLogin capture wizard is finished.');
				break;
		}
		evt.preventDefault();
		evt.preventBubble();
		evt.preventCapture();
		evt.stopPropagation();
	},
	captureGatherInfo: function (target) {		
		var doc = document.commandDispatcher.focusedWindow.document, found = 0;		
		for (var f=0; f < doc.forms.length; f++) {			
			var form = doc.forms[f];
//			alDump('FORM: '+ form.getAttribute('action') +'\nElements #: '+ form.elements.length);			
			for (var i=0; i<form.elements.length; i++) {
				// is this a form element?
				if (form.elements[i] == target) {
					// yes, return form specific index
//					alDump('field is inside form');
					return [1, f, form.getAttribute('method'), i, target.getAttribute('name'), target.getAttribute('id'), target.getAttribute('type')].join(' | ');
				}
			}
		}
		
		// no, return element tagname and index within page
//		alDump('field is outside form');
		var fields = doc.getElementsByTagName(target.tagName);
//		alDump('number of '+ target.tagName +' elements: '+ fields.length);
			
		for (var i=0; i < fields.length; i++) {
			if (fields[i] == target)
				break;
		}
		return [0, target.tagName, i, target.getAttribute('name'), target.getAttribute('id'), target.getAttribute('type'), target.getAttribute('onclick'), target.getAttribute('src'), target.getAttribute('href')].join(' | ');

	},
	errOut: function (level, msg, eWindow, siteId) {
		var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("AutoLogin.");
		var acceptChanges = prefs.getCharPref('site'+siteId).split(' | ')[4];
		var icon = document.getElementById('autologinError');
		// level 0 -- non-critical
		// level 1 -- critical
		// if returns true, error will stop execution
		if (!level) {
			if (acceptChanges=='true') { return false; }
			prefs.setCharPref('lastError',[siteId,msg].join(' | '));
			// laranja
			icon.setAttribute('errstat','0');
			icon.setAttribute('hidden','false');				
			eWindow.addEventListener('unload',autoLoginNukeErrorIcon,true);
			return true;
		} else {
			prefs.setCharPref('lastError',[siteId,msg].join(' | '));
			// vermelho
			icon.setAttribute('errstat','1');
			icon.setAttribute('hidden','false');				
			eWindow.addEventListener('unload',autoLoginNukeErrorIcon,true);
			return true;
		}
	},
	unshuffle: function (input) {
		var output = '',tmpin='',tmp;
	
		for (var j = 0; j < input.length; j+=3) {
			tmp = input.substr(j,3);
			if (tmp.length == 3 && !j%6) 
				tmpin += tmp.charAt(2) + tmp.charAt(1) + tmp.charAt(0);
			else 
				tmpin += tmp;
		}
		input = tmpin;
		
		for (var i = 0; i < input.length; i += 2) {
			tmp = parseInt(input.substr(i,2)) + 23;
			output += decodeURIComponent('%' + tmp.toString(16));
		}	
		return decodeURIComponent(output);
	},
	popIconMsg: function (e) {
		var err = e.currentTarget.getAttribute('errstat')*1;
		var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("AutoLogin.");
		var siteId = prefs.getCharPref('lastError').split(' | ');
		var msg = prefs.getCharPref('lastError').split(' | ')[1];
			siteId = siteId[0];
		switch (err) {
			case 0:
				var loginValues = prefs.getCharPref('site'+siteId).split(' | ');
				// accept changes?
				loginValues[4] = (confirm('[AutoLogin] - Site: '+prefs.getCharPref('site'+siteId).split(' | ')[0]+"\n"+msg)?'true':'false');
				prefs.setCharPref('site'+siteId,loginValues.join(' | '));
				autoLoginNukeErrorIcon();
				break;
			case 1:
				alert(msg);
				autoLoginNukeErrorIcon();
				break;
			default:
				alert(err);
		}
	}
}
